% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.svyContTable.R
\name{print.svyContTable}
\alias{print.svyContTable}
\title{Format and print \code{svyContTable} class objects}
\usage{
\method{print}{svyContTable}(x, digits = 2, pDigits = 3, quote = FALSE,
  missing = FALSE, explain = TRUE, printToggle = TRUE, noSpaces = FALSE,
  nonnormal = NULL, minMax = FALSE, insertLevel = FALSE, test = TRUE,
  smd = FALSE, ...)
}
\arguments{
\item{x}{Object returned by \code{\link{svyCreateContTable}} function.}

\item{digits}{Number of digits to print in the table.}

\item{pDigits}{Number of digits to print for p-values (also used for standardized mean differences).}

\item{quote}{Whether to show everything in quotes. The default is FALSE. If TRUE, everything including the row and column names are quoted so that you can copy it to Excel easily.}

\item{missing}{Whether to show missing data information.}

\item{explain}{Whether to add explanation to the variable names, i.e., (mean (sd) or median [IQR]) is added to the variable names.}

\item{printToggle}{Whether to print the output. If FALSE, no output is created, and a matrix is invisibly returned.}

\item{noSpaces}{Whether to remove spaces added for alignment. Use this option if you prefer to align numbers yourself in other software.}

\item{nonnormal}{A character vector to specify the variables for which the p-values should be those of nonparametric tests. By default all p-values are from normal assumption-based tests (oneway.test).}

\item{minMax}{Whether to use [min,max] instead of [p25,p75] for nonnormal variables. The default is FALSE.}

\item{insertLevel}{Whether to add an empty level column to the left of strata.}

\item{test}{Whether to show p-values. TRUE by default. If FALSE, only the numerical summaries are shown.}

\item{smd}{Whether to show standardized mean differences. FALSE by default. If there are more than one contrasts, the average of all possible standardized mean differences is shown. For individual contrasts, use \code{summary}.}

\item{...}{For compatibility with generic. Ignored.}
}
\value{
A matrix object containing what you see is also invisibly returned. This can be assinged a name and exported via \code{write.csv}.
}
\description{
\code{print} method for the \code{svyContTable} class objects created by \code{\link{CreateContTable}} function.
}
\examples{

## See the examples for svyCreateTableOne()

}
\seealso{
\code{\link{svyCreateTableOne}}, \code{\link{svyCreateCatTable}}, \code{\link{summary.svyCatTable}}
}
\author{
Kazuki Yoshida
}
