% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setClusters.R
\name{setCluster}
\alias{setCluster}
\title{Set where the clusters are}
\usage{
setCluster(
  schema = NULL,
  id = NULL,
  group = NULL,
  member = NULL,
  left = NULL,
  top = NULL,
  width = NULL,
  height = NULL
)
}
\arguments{
\item{schema}{[\code{schema(1)}]\cr In case this information is added to an
already existing schema, provide that schema here (overwrites previous
information).}

\item{id}{[\code{character(1)}]\cr When data are clustered, it is typically
the case that the data are segregated according to a categorical variables
of interest. In such cases, this variable needs to be registered as cluster
ID.}

\item{group}{[\code{character(1)}]\cr When clusters themselves are
clustered, they are typically nested into another categorical variable,
which needs to be registered as group ID.}

\item{member}{[\code{integerish(.)}]\cr For each cluster, specify here to
which group it belongs. Clusters are enumerated from left to right and
from top to bottom.}

\item{left}{[\code{integerish(.)}]\cr The horizontal cell value of the
top-left cell of each cluster. This can also be a vector of values in case
there are several clusters.}

\item{top}{[\code{integerish(.)}]\cr The vertical cell values of the top-left
cell of each cluster. This can also be a vector of values in case there are
several clusters.}

\item{width}{[\code{integerish(.)}]\cr The width of each cluster in cells.
This can also be a vector of values in case there are several clusters.}

\item{height}{[\code{integerish(.)}]\cr The height of each cluster in cells.
This can also be a vector of values in case there are several clusters.}
}
\value{
An object of class \code{\link{schema}}.
}
\description{
There is hardly any limit to how data can be arranged in a spreadsheet, apart
from the apparent organisation into a lattice of cells. However, it is often
the case that data are gathered into topologically coherent chunks. Those
chunks are what is called 'cluster' in \code{tabshiftr}.
}
\details{
Please also take a look at the currently suggested strategy to set
  up a \link[=schema]{schema description}.
}
\examples{
# please check the vignette for examples
}
\seealso{
Other functions to describe table arrangement: 
\code{\link{setFilter}()},
\code{\link{setFormat}()},
\code{\link{setIDVar}()},
\code{\link{setObsVar}()}
}
\concept{functions to describe table arrangement}
