% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{BootCA-class}
\alias{BootCA-class}
\alias{.BootCA}
\title{Partial bootstrap CA}
\description{
An S4 class to store partial bootstrap correspondence analysis results.
}
\section{Slots}{

\describe{
\item{\code{id}}{A \code{\link{character}} string specifying the unique
identifier of the corresponding matrix (UUID v4).}

\item{\code{rows}}{A list of length three giving the vertices coordinates
(\code{x}, \code{y}) of the samples convex hull and a identifier
(\code{id}) to link each row to a sample.}

\item{\code{columns}}{A list of length three giving the vertices coordinates
(\code{x}, \code{y}) of the variables convex hull and a identifier
(\code{id}) to link each row to a variable.}

\item{\code{lengths}}{A list of two named \code{\link{numeric}} vectors giving the
convex hull maximum dimension length of samples and variables, respectively.}

\item{\code{cutoff}}{A length-two \code{\link{numeric}} vector giving the cutoff
value for samples and variables selection, respectively.}

\item{\code{keep}}{A list of two \code{\link{integer}} vectors giving the subscript
of the samples and variables to be kept, respectively.}
}}

\section{Subset}{

 In the code snippets below, \code{x} is a \code{BootCA} object.
 \describe{
  \item{\code{x[i, j, drop]}}{Extracts informations from a slot selected by
  subscript \code{i} thru \code{j} (see examples). \code{i} should be one of
  "\code{rows}" or "\code{columns}". Any unambiguous substring can be
  given. \code{j} is a \code{\link{numeric}}, \code{\link{integer}} or
  \code{\link{character}} vector or empty (missing) or \code{NULL}.
  Numeric values are coerced to \code{\link{integer}} as by
  \code{\link{as.integer}} (and hence truncated towards zero). Character
  vectors will be matched to the name of the elements. An empty index
  (a comma separated blank) indicates that all entries in that dimension are
  selected.}
  \item{\code{x[[i]]}}{Extracts informations from a slot selected by
  subscript \code{i}. \code{i} should be one of "\code{id}",
  "\code{rows}", "\code{columns}", "\code{lengths}", "\code{cutoff}" or
  "\code{keep}". Any unambiguous substring can be given.}
 }
}

\seealso{
Other class: 
\code{\link{DateModel-class}},
\code{\link{DiversityIndex}},
\code{\link{PermutationOrder-class}}
}
\author{
N. Frerebeau
}
\concept{class}
