% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_bertin.R, R/plot_ford.R
\docType{methods}
\name{plot_bar}
\alias{plot_bar}
\alias{seriographe}
\alias{Bertin}
\alias{Ford}
\alias{plot_bertin}
\alias{plot_bertin-method}
\alias{plot_ford}
\alias{plot_ford-method}
\alias{plot_bertin,matrix-method}
\alias{plot_bertin,data.frame-method}
\alias{plot_ford,matrix-method}
\alias{plot_ford,data.frame-method}
\title{Bar Plot}
\usage{
plot_bertin(object, ...)

plot_ford(object, ...)

\S4method{plot_bertin}{matrix}(object, threshold = NULL, scale = NULL)

\S4method{plot_bertin}{data.frame}(object, threshold = NULL, scale = NULL)

\S4method{plot_ford}{matrix}(object, EPPM = FALSE)

\S4method{plot_ford}{data.frame}(object, EPPM = FALSE)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each class).}

\item{...}{Currently not used.}

\item{threshold}{A \code{\link{function}} that takes a numeric vector as argument and
returns a numeric threshold value (see below). If \code{NULL} (the default), no
threshold is computed.}

\item{scale}{A \code{\link{function}} used to scale each variable, that takes a numeric
vector as argument and returns a numeric vector. If \code{NULL} (the default), no
scaling is performed.}

\item{EPPM}{A \code{\link{logical}} scalar: should the EPPM be drawn (see below)?}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots a Bertin, Ford (battleship curve) or Dice-Leraas diagram.
}
\details{
If \code{EPPM} is \code{TRUE} and if a relative abundance is greater than
the mean percentage of the type, the exceeding part is highlighted.
}
\section{Bertin Matrix}{

As de Falguerolles \emph{et al.} (1997) points out:
"In abstract terms, a Bertin matrix is a matrix
of  displays. \link{...} To fix ideas, think of a data matrix, variable by case,
with real valued variables. For each variable, draw a bar chart of variable
value by case. High-light all bars representing a value above some sample
threshold for that variable."
}

\section{EPPM}{

This positive difference from the column mean percentage (in french "écart
positif au pourcentage moyen", EPPM) represents a deviation from the
situation of statistical independence. As independence can be interpreted as
the absence of relationships between types and the chronological order of
the assemblages, \code{EPPM} is a useful tool to explore significance
of relationship between rows and columns related to seriation (Desachy
2004).
}

\examples{
\donttest{
## Ceramic data
data("mississippi", package = "folio")

## Plot a Bertin diagram...
## ...without threshold
plot_bertin(mississippi)
## ...with variables scaled to 0-1 and the variable mean as threshold
scale_01 <- function(x) (x - min(x)) / (max(x) - min(x))
plot_bertin(mississippi, threshold = mean, scale = scale_01)

## Abundance data
## Coerce dataset to a count matrix (data from Desachy 2004)
data("compiegne", package = "folio")

## Plot a Ford diagram...
## ...without threshold
plot_ford(compiegne)
## ...with EPPM
plot_ford(compiegne, EPPM = TRUE)
}
}
\references{
Bertin, J. (1977). \emph{La graphique et le traitement graphique de
l'information}. Paris: Flammarion. Nouvelle Bibliothèque Scientifique.

de Falguerolles, A., Friedrich, F. & Sawitzki, G. (1997). A Tribute to J.
Bertin's Graphical Data Analysis. In W. Badilla & F. Faulbaum (eds.),
\emph{SoftStat '97: Advances in Statistical Software 6}. Stuttgart: Lucius
& Lucius, p. 11-20.

Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
graphique pour tableaux de comptages. \emph{Revue archéologique de Picardie},
3(1), 39-56. \doi{10.3406/pica.2004.2396}.

Ford, J. A. (1962). \emph{A quantitative method for deriving cultural
chronology}. Washington, DC: Pan American Union. Technical manual 1.
}
\seealso{
\code{\link[=eppm]{eppm()}}

Other plot methods: 
\code{\link{plot_diversity}},
\code{\link{plot_heatmap}()},
\code{\link{plot_line}},
\code{\link{plot_spot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
