% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_stats.R
\name{modus}
\alias{modus}
\title{Modus}
\usage{
modus(x, as_character = TRUE, reduce = TRUE, na.rm = FALSE)
}
\arguments{
\item{x}{A \code{vector} with numeric data.}

\item{as_character}{Always return a character. \code{TRUE} by default, or \link[dplyr]{summarize}
will be very unpleased.}

\item{reduce}{Since \code{mode} can be of length > 1, this option pastes the result into a
single character value}

\item{na.rm}{If \code{TRUE}, missing values (\code{NA}) will be ignored.}
}
\value{
A \code{vector} of length 1 of type \code{numeric} or \code{character}, depending
on input.
}
\description{
Calculate the mode of a numeric vector. German name kept to avoid confusion.
}
\examples{
\dontrun{
x <- c(1, 2, 6, 2, 1, 5, 7, 8, 4, 3, 2, 2, 2)
modus(x)

# Or for nominal data
x <- structure(c(2L, 1L, 2L, 2L, 2L, 1L), .Label = c("Ja", "Nein"), class = "factor")
modus(x)
}
}

