% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_assumptions.R
\name{tadaa_levene}
\alias{tadaa_levene}
\title{Levene's Test for Homoskedasticity}
\usage{
tadaa_levene(data, formula, center = "median", print = "df")
}
\arguments{
\item{data}{Data for the test}

\item{formula}{Formula specifiyng groups, passed to \code{leveneTest}.}

\item{center}{Method to use, either \code{median} (default for robustness) or \code{mean}.}

\item{print}{Print method, default \code{df}: A regular \code{data.frame}.
Otherwise passed to \link[pixiedust]{sprinkle_print_method} for fancyness.}
}
\value{
A \code{data.frame} by default, otherwise \code{dust} object, depending on \code{print}.
}
\description{
A thin wrapper around \link[car]{leveneTest} with some formatting done.
}
\note{
The case of \code{center = "median"} is technically called \emph{Brown–Forsythe test},
so if that's selected the header for non-\code{df} returns will reflect that.
}
\examples{
tadaa_levene(ngo, deutsch ~ jahrgang, print = "console")
tadaa_levene(ngo, deutsch ~ jahrgang * geschl, print = "console")
}
\seealso{
Other Tadaa-functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_kruskal}}, \code{\link{tadaa_nom}},
  \code{\link{tadaa_normtest}},
  \code{\link{tadaa_one_sample}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_pairwise_gh}},
  \code{\link{tadaa_pairwise_tukey}},
  \code{\link{tadaa_pairwise_t}},
  \code{\link{tadaa_t.test}}, \code{\link{tadaa_wilcoxon}}
}
