% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other.R
\name{selectGrid}
\alias{selectGrid}
\title{Selects a grid of indices.}
\usage{
selectGrid(cst, d, nonzero = 2, locations = NULL, maxDistance = 10^6)
}
\arguments{
\item{cst}{A vector containing the values used to construct the grid. Must contain 0.}

\item{d}{An integer, representing the dimension.}

\item{nonzero}{An vector containing integers between \eqn{2} and \eqn{d}, representing the number of non-zero elements in every row of the grid. Defaults to \eqn{2}.}

\item{locations}{A \code{d} x \eqn{2} matrix containing the Cartesian coordinates of \eqn{d} points in the plane. Used for the Brown-Resnick process only. If not \code{NULL}, then \code{cst} must be \code{c(0,1)} and \code{nonzero} must be \code{2}.}

\item{maxDistance}{If \code{locations} is not \code{NULL}, pairs of locations with distance not larger than \code{maxDistance} will be selected.}
}
\value{
A matrix with \code{q} rows and \code{d} columns, where every row represents a vector in which we will evaluate the stable tail dependence function (for the weighted least squares estimator) or where every row indicates which pairs of variables to use (for the M-estimator)
}
\description{
Returns a regular grid of indices in which to evaluate the stable tail dependence function.
}
\examples{
selectGrid(cst = c(0,0.5,1), d = 3, nonzero = c(2,3))
locations <- cbind(rep(1:3, each = 3), rep(1:3,3))
selectGrid(c(0,1), d = 9, locations = locations, maxDistance = 1.5)
}

