% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\docType{class}
\name{ASTFunction}
\alias{ASTFunction}
\title{A specified function call as an ASTNode}
\format{\code{\link{R6Class}} object.}
\usage{
ASTFunction
}
\description{
A specified function call as an ASTNode
}
\section{Fields}{

\describe{
\item{\code{value}}{The name of the function.}

\item{\code{r_expr}}{A string containing the raw r expression from inside the parenthesis}
}}

\section{Methods}{

\describe{
  \item{\code{new(value, r_expr)}}{Create one with the given value and r_expr}
  \item{\code{terms()}}{Returns the node}
  \item{\code{factors()}}{Returns self as a factor}
  \item{\code{distribute()}}{Applies the distributive property to the node, and returns the resulting node.}
  \item{\code{string()}}{Returns the string formula of the node}
  \item{\code{reduce(data)}}{Given a set of data, perform the logical reduction of the current node.}
}
}

\examples{
ASTFunction$new("log", "x+2")$string()

}
\keyword{data}
