% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R, R/compile-rms.R
\name{tangram}
\alias{tangram}
\alias{tangram.numeric}
\alias{tangram.data.frame}
\alias{tangram.formula}
\alias{tangram.character}
\alias{tangram.rms}
\title{Table creation methods}
\usage{
tangram(x, ...)

\method{tangram}{numeric}(x, cols, embedded = FALSE, ...)

\method{tangram}{data.frame}(x, colheader = NA, ...)

\method{tangram}{formula}(x, data, transforms = hmisc_style, after = NA,
  ...)

\method{tangram}{character}(x, data, transforms = hmisc_style, after = NA,
  ...)

\method{tangram}{rms}(x, data = NULL, short.labels = NULL,
  footnote = NULL, rnd.digits = 2, rnd.stats = rnd.digits, ...)
}
\arguments{
\item{x}{object; depends on S3 type, could be rows, formula, string of a formula, data.frame or numerical rows, an rms.model}

\item{...}{addition models or data supplied to table construction routines}

\item{cols}{numeric; An integer of the number of cols to create}

\item{embedded}{logical; Will this table be embedded inside another}

\item{colheader}{character; Use as column headers in final table}

\item{data}{data.frame; data to use for rendering tangram object}

\item{transforms}{list of lists of functions; that contain the transformation to apply for summarization}

\item{after}{function or list of functions; one or more functions to further process an abstract table}

\item{short.labels}{numeric; Named vector of variable labels to replace in interaction rows. Must be in format c("variable name" = "shortened label").}

\item{footnote}{character; A string to add to the table as a footnote.}

\item{rnd.digits}{numeric; Digits to round reference, comparison, result and CI values to. Defaults to 2.}

\item{rnd.stats}{numeric; Digits to round model LR, R2, etc to. Defaults to rnd.digits.}
}
\value{
A tangram object (a table).
}
\description{
The tangram method is the principal method to create tables. It uses
R3 method dispatch. If one specifies rows and columns, one gets an empty
table of the given size. A formula or character will invoke the parser
and process the specified data into a table like \code{Hmisc::summaryM}.
Given an \code{rms} object it will summarize that model in a table. A
\code{data.frame} is converted directly into a table as well for later
rendering. Can create tables from summary.rms(), anova.rms(), and other rms object info to create a
single pretty table of model results. The rms and Hmisc packages are required.
}
\examples{
tangram(1, 1)
tangram(data.frame(x=1:3, y=c('a','b','c')))
tangram(drug ~ bili + albumin + protime + sex + age + spiders, pbc)
tangram("drug ~ bili + albumin + stage::Categorical + protime + sex + age + spiders", pbc)
}
