% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_render.R, R/tar_render_raw.R
\name{tar_render}
\alias{tar_render}
\alias{tar_render_raw}
\title{Target with an R Markdown document.}
\usage{
tar_render(
  name,
  path,
  output_file = NULL,
  working_directory = NULL,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = "main",
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description"),
  quiet = TRUE,
  ...
)

tar_render_raw(
  name,
  path,
  output_file = NULL,
  working_directory = NULL,
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  error = targets::tar_option_get("error"),
  deployment = "main",
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description"),
  quiet = TRUE,
  render_arguments = quote(list())
)
}
\arguments{
\item{name}{Name of the target.
\code{\link[=tar_render]{tar_render()}} expects an unevaluated symbol for the \code{name} argument,
whereas
\code{\link[=tar_render_raw]{tar_render_raw()}} expects a character string for \code{name}.}

\item{path}{Character string, file path to the R Markdown source file.
Must have length 1.}

\item{output_file}{Character string, file path to the rendered output file.}

\item{working_directory}{Optional character string,
path to the working directory
to temporarily set when running the report.
The default is \code{NULL}, which runs the report from the
current working directory at the time the pipeline is run.
This default is recommended in the vast majority of cases.
To use anything other than \code{NULL}, you must manually set the value
of the \code{store} argument relative to the working directory in all calls
to \code{tar_read()} and \code{tar_load()} in the report. Otherwise,
these functions will not know where to find the data.}

\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target runs or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
\item \code{"trim"}: all currently running targets stay running. A queued
target is allowed to start if:
\enumerate{
\item It is not downstream of the error, and
\item It is not a sibling branch from the same \code{\link[targets:tar_target]{tar_target()}} call
(if the error happened in a dynamic branch).
}

The idea is to avoid starting any new work that the immediate error
impacts. \code{error = "trim"} is just like \code{error = "abridge"},
but it allows potentially healthy regions of the dependency graph
to begin running.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
}}

\item{memory}{Character of length 1, memory strategy.
If \code{"persistent"}, the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
If \code{"transient"}, the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
For cloud-based dynamic files
(e.g. \code{format = "file"} with \code{repository = "aws"}),
this memory strategy applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical, whether to run \code{base::gc()}
just before the target runs.}

\item{deployment}{Character of length 1. If \code{deployment} is
\code{"main"}, then the target will run on the central controlling R process.
Otherwise, if \code{deployment} is \code{"worker"} and you set up the pipeline
with distributed/parallel computing, then
the target runs on a parallel worker. For more on distributed/parallel
computing in \code{targets}, please visit
\url{https://books.ropensci.org/targets/crew.html}.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get dispatched earlier
(and polled earlier in \code{\link[targets:tar_make_future]{tar_make_future()}}).}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target runs.
\item \code{"worker"}: the worker loads the targets dependencies.
\item \code{"none"}: the dependencies are not loaded at all.
This choice is almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{description}{Character of length 1, a custom free-form human-readable
text description of the target. Descriptions appear as target labels
in functions like \code{\link[targets:tar_manifest]{tar_manifest()}} and \code{\link[targets:tar_visnetwork]{tar_visnetwork()}},
and they let you select subsets of targets for the \code{names} argument of
functions like \code{\link[targets:tar_make]{tar_make()}}. For example,
\code{tar_manifest(names = tar_described_as(starts_with("survival model")))}
lists all the targets whose descriptions start with the character
string \code{"survival model"}.}

\item{quiet}{An option to suppress printing during rendering from knitr,
pandoc command line and others. To only suppress printing of the last
"Output created: " message, you can set \code{rmarkdown.render.message} to
\code{FALSE}}

\item{...}{Named arguments to \code{rmarkdown::render()}.
These arguments are evaluated when the target actually runs in
\code{tar_make()}, not when the target is defined. That means, for
example, you can use upstream targets as parameters of
parameterized R Markdown reports.
\code{tar_render(your_target, "your_report.Rmd", params = list(your_param = your_target))} # nolint
will run \code{rmarkdown::render("your_report.Rmd", params = list(your_param = your_target))}. # nolint
For parameterized reports, it is recommended to supply a distinct
\code{output_file} argument to each \code{tar_render()} call
and set useful defaults for parameters in the R Markdown source.
See the examples section for a demonstration.}

\item{render_arguments}{Optional language object with a list
of named arguments to \code{rmarkdown::render()}.
Cannot be an expression object.
(Use \code{quote()}, not \code{expression()}.)
The reason for quoting is that these arguments may depend on
upstream targets whose values are not available at
the time the target is defined, and because \code{tar_render_raw()}
is the "raw" version of a function, we want to avoid
all non-standard evaluation.}
}
\value{
A target object with \code{format = "file"}.
When this target runs, it returns a character vector
of file paths: the rendered document, the source file,
and then the \verb{*_files/} directory if it exists.
Unlike \code{rmarkdown::render()},
all returned paths are \emph{relative} paths to ensure portability
(so that the project can be moved from one file system to another
without invalidating the target).
See the "Target objects" section for background.
}
\description{
Shorthand to include an R Markdown document in a
\code{targets} pipeline.

\code{\link[=tar_render]{tar_render()}} expects an unevaluated symbol for the \code{name} argument,
and it supports named \code{...} arguments for \code{rmarkdown::render()}
arguments.
\code{\link[=tar_render_raw]{tar_render_raw()}} expects a character string for \code{name} and
supports an evaluated expression object
\code{render_arguments} for \code{rmarkdown::render()} arguments.
}
\details{
\code{tar_render()} is an alternative to \code{tar_target()} for
R Markdown reports that depend on other targets. The R Markdown source
should mention dependency targets with \code{tar_load()} and \code{tar_read()}
in the active code chunks (which also allows you to render the report
outside the pipeline if the \verb{_targets/} data store already exists).
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
Then, \code{tar_render()} defines a special kind of target. It
1. Finds all the \code{tar_load()}/\code{tar_read()} dependencies in the report
and inserts them into the target's command.
This enforces the proper dependency relationships.
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
2. Sets \code{format = "file"} (see \code{tar_target()}) so \code{targets}
watches the files at the returned paths and reruns the report
if those files change.
3. Configures the target's command to return both the output
report files and the input source file. All these file paths
are relative paths so the project stays portable.
4. Forces the report to run in the user's current working directory
instead of the working directory of the report.
5. Sets convenient default options such as \code{deployment = "main"}
in the target and \code{quiet = TRUE} in \code{rmarkdown::render()}.
}
\section{Literate programming limitations}{

Literate programming files are messy and variable,
so functions like \code{\link[=tar_render]{tar_render()}} have limitations:
* Child documents are not tracked for changes.
* Upstream target dependencies are not detected if \code{tar_read()}
and/or \code{tar_load()} are called from a user-defined function.
In addition, single target names must be mentioned and they must
be symbols. \code{tar_load("x")} and \code{tar_load(contains("x"))} may not
detect target \code{x}.
* Special/optional input/output files may not be detected in all cases.
* \code{\link[=tar_render]{tar_render()}} and friends are for local files only. They do not
integrate with the cloud storage capabilities of \code{targets}.
}

\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({  # tar_dir() runs code from a temporary directory.
# Unparameterized R Markdown:
lines <- c(
  "---",
  "title: report.Rmd source file",
  "output_format: html_document",
  "---",
  "Assume these lines are in report.Rmd.",
  "```{r}",
  "targets::tar_read(data)",
  "```"
)
# Include the report in a pipeline as follows.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_target(data, data.frame(x = seq_len(26), y = letters)),
    tar_render(report, "report.Rmd")
  )
}, ask = FALSE)
# Then, run the targets pipeline as usual.

# Parameterized R Markdown:
lines <- c(
  "---",
  "title: 'report.Rmd source file with parameters'",
  "output_format: html_document",
  "params:",
  "  your_param: \"default value\"",
  "---",
  "Assume these lines are in report.Rmd.",
  "```{r}",
  "print(params$your_param)",
  "```"
)
# Include the report in the pipeline as follows.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_target(data, data.frame(x = seq_len(26), y = letters)),
    tar_render(
      name = report,
      "report.Rmd",
      params = list(your_param = data)
    ),
    tar_render_raw(
      name = "report2",
      "report.Rmd",
      params = quote(list(your_param = data))
    )
  )
}, ask = FALSE)
})
# Then, run the targets pipeline as usual.
}
}
\seealso{
Other Literate programming targets: 
\code{\link{tar_knit}()},
\code{\link{tar_quarto}()},
\code{\link{tar_quarto_rep}()},
\code{\link{tar_render_rep}()}
}
\concept{Literate programming targets}
