% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RATE.R
\name{RATE}
\alias{RATE}
\title{Responder Average Treatment Effect}
\usage{
RATE(
  response,
  post.treatment,
  treatment,
  data,
  family = gaussian(),
  M = 5,
  pr.treatment,
  treatment.level,
  SL.args.response = list(family = gaussian(), SL.library = c("SL.mean", "SL.glm")),
  SL.args.post.treatment = list(family = binomial(), SL.library = c("SL.mean", "SL.glm")),
  preprocess = NULL,
  efficient = TRUE,
  ...
)
}
\arguments{
\item{response}{Response formula (e.g, Y~D*A)}

\item{post.treatment}{Post treatment marker formula (e.g., D~W)}

\item{treatment}{Treatment formula (e.g, A~1)}

\item{data}{data.frame}

\item{family}{Exponential family for response (default gaussian)}

\item{M}{Number of folds in cross-fitting (M=1 is no cross-fitting)}

\item{pr.treatment}{(optional) Randomization probability of treatment.}

\item{treatment.level}{Treatment level in binary treatment (default 1)}

\item{SL.args.response}{Arguments to SuperLearner for the response model}

\item{SL.args.post.treatment}{Arguments to SuperLearner for the post treatment indicator}

\item{preprocess}{(optional) Data preprocessing function}

\item{efficient}{If TRUE, the estimate will be efficient. If FALSE, the estimate will be a simple plug-in estimate.}

\item{...}{Additional arguments to lower level functions}
}
\value{
estimate object
}
\description{
Estimation of the Average Treatment Effect among Responders
}
\author{
Andreas Nordland, Klaus K. Holst
}
