% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_exist_objects.R
\name{tar_exist_objects}
\alias{tar_exist_objects}
\title{Check if local output data exists for one or more targets.}
\usage{
tar_exist_objects(names)
}
\arguments{
\item{names}{Character vector of target names.}
}
\value{
Logical of length \code{length(names)}, whether
each given target has an existing file in \verb{_targets/objects/}
for the current project.
}
\description{
Check if the local data files exist in
\verb{_targets/objects/} for one or more targets.
}
\details{
To learn more about local storage in \code{targets}, visit
\url{https://books.ropensci.org/targets/files.html#internal-files}.
}
\examples{
tar_exist_objects(c("target1", "target2"))
}
\seealso{
Other existence: 
\code{\link{tar_exist_meta}()},
\code{\link{tar_exist_process}()},
\code{\link{tar_exist_progress}()},
\code{\link{tar_exist_script}()}
}
\concept{existence}
