% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{is_branch}
\alias{is_branch}
\title{Test if taxa are branches}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.}
}
\value{
A \code{logical} of length equal to the number of taxa.
}
\description{
Test if taxa are branches in a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object. Branches
are taxa in the interior of the tree that are not \code{\link[=roots]{roots()}}, \code{\link[=stems]{stems()}}, or
\code{\link[=leaves]{leaves()}}.
\preformatted{
obj$is_branch()
is_branch(obj)}
}
\examples{
is_branch(ex_taxmap)

}
\seealso{
Other taxonomy data functions: \code{\link{id_classifications}},
  \code{\link{is_leaf}}, \code{\link{is_root}},
  \code{\link{is_stem}}, \code{\link{map_data}},
  \code{\link{n_subtaxa_1}}, \code{\link{n_subtaxa}},
  \code{\link{n_supertaxa}},
  \code{\link{name_classifications}},
  \code{\link{taxon_ids}}, \code{\link{taxon_indexes}},
  \code{\link{taxon_names}}, \code{\link{taxon_ranks}}
}
