% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--docs.R
\name{select_obs}
\alias{select_obs}
\title{Subset columns in a \code{\link[=taxmap]{taxmap()}} object}
\arguments{
\item{obj}{An object of type \code{\link[=taxmap]{taxmap()}}}

\item{target}{The name of the list/vector/table in \code{obj$data} to filter}

\item{...}{One or more column names to return in the new object. Each can be
one of two things: \describe{ \item{expression with unquoted column
name}{The name of a column in \code{obj$data[[target]]} typed as if it was
a variable on its own.} \item{\code{numeric}}{Indexes of columns in
\code{obj$data[[target]]}} } To match column names with a character vector,
use \code{matches("my_col_name")}. To match a logical vector, convert it to
a column index using \code{which}.

[[target]: R:[target
[[target]: R:[target}
}
\value{
An object of type \code{\link[=taxmap]{taxmap()}}
}
\description{
Subsets columns in a \code{\link[=taxmap]{taxmap()}} object. Takes and returns a
\code{\link[=taxmap]{taxmap()}} object. Any variable name that appears in
\code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own. See
\code{\link[dplyr:select]{dplyr::select()}} for the inspiration for this function and more
information. Calling the function using the \code{obj$select_obs(...)} style
edits "obj" in place, unlike most R functions. However, calling the function
using the \code{select_obs(obj, ...)} imitates R's traditional copy-on-modify
semantics, so "obj" would not be changed; instead a changed version would be
returned, like most R functions.
\preformatted{
obj$select_obs(target, ...)
select_obs(obj, target, ...)}
}
\examples{
# Selecting a column by name
select_obs(ex_taxmap, "info", dangerous)

# Selecting a column by index
select_obs(ex_taxmap, "info", 3)

# Selecting a column by regular expressions
select_obs(ex_taxmap, "info", matches("^n"))

}
\seealso{
Other taxmap manipulation functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_obs}},
  \code{\link{filter_taxa}}, \code{\link{mutate_obs}},
  \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{transmute_obs}}
}
