% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--parsers.R
\name{check_class_col}
\alias{check_class_col}
\title{Check for name/index in input data}
\usage{
check_class_col(tax_data, column)
}
\arguments{
\item{tax_data}{A table, list, or vector that contain sequence IDs, taxon
IDs, or taxon names.
\itemize{
\item tables: The \code{column} option must be used to specify which column
contains the sequence IDs, taxon IDs, or taxon names.
\item lists: There must be only one item per list entry unless the \code{column}
option is used to specify what item to use in each list entry.
\item vectors: simply a vector of sequence IDs, taxon IDs, or taxon names.
}}

\item{column}{(\code{character} or \code{integer}) The name or index of the column that
contains information used to lookup classifications. This only applies when
a table or list is supplied to \code{tax_data}.}
}
\description{
Used by parse_tax_data and lookup_tax_data to check that columm/class_col is valid for the input data
}
\keyword{internal}
