% Generated by roxygen2 (4.0.1): do not edit by hand
\name{get_ubioid}
\alias{get_ubioid}
\title{Get the uBio id for a search term.}
\usage{
get_ubioid(searchterm, searchtype = "scientific", ask = TRUE,
  verbose = TRUE)
}
\arguments{
\item{searchterm}{character; A vector of common or scientific names.}

\item{searchtype}{character; One of 'scientific' or 'common', or any unique abbreviation}

\item{ask}{logical; should get_tsn be run in interactive mode?
If TRUE and more than one TSN is found for teh species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; should progress be printed?}
}
\value{
A vector of uBio ids. If a taxon is not found NA is given. If more than one uBio
   id is found the function asks for user input (if ask = TRUE), otherwise returns NA.
   Comes with an attribute \emph{match} to investigate the reason for NA (either 'not found',
   'found' or if ask = FALSE 'multi match')
}
\description{
Retrieve the uBio id of a taxon. This function uses \code{\link[taxize]{ubio_search}} internally
to search for names.
}
\examples{
\donttest{
get_ubioid(searchterm = "Astragalus aduncus")
get_ubioid(c("Salvelinus fontinalis","Pomacentrus brachialis"))
splist <- c("Salvelinus fontinalis", 'Pomacentrus brachialis', "Leptocottus armatus",
		"Clinocottus recalvus", "Trachurus trachurus", "Harengula clupeola")
get_ubioid(splist, verbose=FALSE)

# When not found
get_ubioid(searchterm="howdy")
get_ubioid(c("Salvelinus fontinalis", "howdy"))

# Using common names
get_ubioid(searchterm="great white shark", searchtype="common")
get_ubioid(searchterm=c("bull shark", "whale shark"), searchtype="common")
}
}
\seealso{
\code{\link[taxize]{get_uid}}, \code{\link[taxize]{ubio_search}}
}

