% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_tpsid.R
\name{get_tpsid}
\alias{as.data.frame.tpsid}
\alias{as.tpsid}
\alias{as.tpsid.character}
\alias{as.tpsid.data.frame}
\alias{as.tpsid.list}
\alias{as.tpsid.numeric}
\alias{as.tpsid.tpsid}
\alias{get_tpsid}
\alias{get_tpsid_}
\title{Get the NameID codes from Tropicos for taxonomic names.}
\usage{
get_tpsid(sciname, ask = TRUE, verbose = TRUE, key = NULL, rows = NA,
  ...)

as.tpsid(x, check = TRUE)

\method{as.tpsid}{tpsid}(x, check = TRUE)

\method{as.tpsid}{character}(x, check = TRUE)

\method{as.tpsid}{list}(x, check = TRUE)

\method{as.tpsid}{numeric}(x, check = TRUE)

\method{as.tpsid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{tpsid}(x, ...)

get_tpsid_(sciname, verbose = TRUE, key = NULL, rows = NA, ...)
}
\arguments{
\item{sciname}{(character) One or more scientific name's as a vector or list.}

\item{ask}{logical; should get_tpsid be run in interactive mode?
If TRUE and more than one ID is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; If TRUE the actual taxon queried is printed on the console.}

\item{key}{Your API key; loads from .Rprofile.}

\item{rows}{numeric; Any number from 1 to inifity. If the default NA, all rows are considered.
Note that this function still only gives back a tpsid class object with one to many identifiers.
See \code{\link[taxize]{get_tpsid_}} to get back all, or a subset, of the raw data that you are
presented during the ask process.}

\item{...}{Other arguments passed to \code{\link[taxize]{tp_search}}.}

\item{x}{Input to \code{\link{as.tpsid}}}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link{as.tpsid}}}
}
\value{
A vector of unique identifiers. If a taxon is not found NA.
If more than one ID is found the function asks for user input.
}
\description{
Get the NameID codes from Tropicos for taxonomic names.
}
\examples{
\dontrun{
get_tpsid(sciname='Poa annua')
get_tpsid(sciname='Pinus contorta')

get_tpsid(c("Poa annua", "Pinus contorta"))

# specify rows to limit choices available
get_tpsid('Poa annua')
get_tpsid('Poa annua', rows=1)
get_tpsid('Poa annua', rows=25)
get_tpsid('Poa annua', rows=1:2)

# When not found, NA given (howdy is not a species name, and Chrinomus is a fly)
get_tpsid("howdy")
get_tpsid(c("Chironomus riparius", "howdy"))

# pass to classification function to get a taxonomic hierarchy
classification(get_tpsid(sciname='Poa annua'))

# factor class names are converted to character internally
spnames <- as.factor(c("Poa annua", "Pinus contorta"))
class(spnames)
get_tpsid(spnames)

# pass in a list, works fine
get_tpsid(list("Poa annua", "Pinus contorta"))

# Convert a tpsid without class information to a tpsid class
as.tpsid(get_tpsid("Pinus contorta")) # already a tpsid, returns the same
as.tpsid(get_tpsid(c("Chironomus riparius","Pinus contorta"))) # same
as.tpsid(24900183) # numeric
as.tpsid(c(24900183,50150089,50079838)) # numeric vector, length > 1
as.tpsid("24900183") # character
as.tpsid(c("24900183","50150089","50079838")) # character vector, length > 1
as.tpsid(list("24900183","50150089","50079838")) # list, either numeric or character
## dont check, much faster
as.tpsid("24900183", check=FALSE)
as.tpsid(24900183, check=FALSE)
as.tpsid(c("24900183","50150089","50079838"), check=FALSE)
as.tpsid(list("24900183","50150089","50079838"), check=FALSE)

(out <- as.tpsid(c(24900183,50150089,50079838)))
data.frame(out)
as.tpsid( data.frame(out) )

# Get all data back
get_tpsid_("Poa annua")
get_tpsid_("Poa annua", rows=2)
get_tpsid_("Poa annua", rows=1:2)
get_tpsid_(c("asdfadfasd","Pinus contorta"), rows=1:5)
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{get_tpsid}}
}

