% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_parse.R
\name{gbif_parse}
\alias{gbif_parse}
\title{Parse taxon names using the GBIF name parser.}
\usage{
gbif_parse(scientificname, ...)
}
\arguments{
\item{scientificname}{(character) scientific names}

\item{...}{Further args passed on to \link[crul:verb-POST]{crul::verb-POST}}
}
\value{
A \code{data.frame} containing fields extracted from parsed
taxon names. Fields returned are the union of fields extracted from
all species names in \code{scientificname}.
}
\description{
Parse taxon names using the GBIF name parser.
}
\examples{
\dontrun{
gbif_parse(scientificname='x Agropogon littoralis')
gbif_parse(c('Arrhenatherum elatius var. elatius',
             'Secale cereale subsp. cereale', 'Secale cereale ssp. cereale',
             'Vanessa atalanta (Linnaeus, 1758)'))
}
}
\references{
https://www.gbif.org/tools/name-parser/about
}
\seealso{
\code{\link[=gni_parse]{gni_parse()}}
}
\author{
John Baumgartner \email{johnbb@student.unimelb.edu.au}
}
