% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shared.R
\name{shared.repertoire}
\alias{shared.matrix}
\alias{shared.repertoire}
\title{Shared TCR repertoire managing and analysis}
\usage{
shared.repertoire(.datalist, .type = 'avc', .min.ppl = 1, .head = -1,
                  .clear = T, .verbose = T, .by.col = '', .sum.col = '',
                  .max.ppl = length(.datalist))

shared.matrix(.shared.rep)
}
\arguments{
\item{.datalist}{List with data frames.}

\item{.type}{String of length 3 denotes how to create a shared repertoire. See "Details" for
more information. If supplied, than parameters \code{.by.col} and \code{.sum.col} will be ignored. If not supplied, than columns
in \code{.by.col} and \code{.sum.col} will be used.}

\item{.min.ppl}{At least how many people must have a sequence to leave this sequence in the shared repertoire.}

\item{.head}{Parameter for the \code{head} function, applied to all data frames before clearing.}

\item{.clear}{If T than remove all sequences which have symbols "~" or "*" (i.e., out-of-frame sequences for amino acid sequences).}

\item{.verbose}{If T than output progress.}

\item{.by.col}{Character vector with names of columns with sequences and their parameters (like segment) for using for creating a shared repertoire.}

\item{.sum.col}{Character vector of length 1 with names of the column with count, percentage or any other numeric chaaracteristic of sequences for using for creating a shared repertoire.}

\item{.max.ppl}{At most how many people must have a sequence to leave this sequence in the shared repertoire.}

\item{.shared.rep}{Shared repertoire.}
}
\value{
Data frame for \code{shared.repertoire}, matrix for \code{shared.matrix}.
}
\description{
Generate a repertoire of shared sequences - sequences presented in more than one subject. If sequence is appeared more than once in the one
repertoire, than only the first appeared one will be choosed for a shared repertoire.

\code{shared.repertoire} - make a shared repertoire of sequences from the given list of data frames.

\code{shared.matrix} - leave columns, which related to the count of sequences in people, and return them as a matrix.
I.e., this functions will remove such columns as 'CDR3.amino.acid.sequence', 'V.segments', 'People'.
}
\details{
Parameter \code{.type} is a string of length 3, where:
\enumerate{
 \item First character stands either for the letter 'a' for taking the "CDR3.amino.acid.sequence" column or
for the letter 'n' for taking the "CDR3.nucleotide.sequence" column.
 \item Second character stands whether or not take the V.segments column. Possible values are '0' (zero) stands
for taking no additional columns, 'v' stands for taking the "V.segments" column.
 \item Third character stands for name of the column to choose as numeric characteristic of sequences. Possible values are
"c" for the "Read.count" column, "p" for the "Read.proportion" column, "r" for the "Rank" column or "i" for the "Index" column.
If "Rank" or "Index" isn't in the given repertoire, than it will be created using \code{set.rank} function using default "Read.count" column.
}
}
\examples{
\dontrun{
# Set "Rank" column in data by "Read.count" column.
# This is doing automatically in shared.repertoire() function
# if the "Rank" column hasn't been found.
immdata <- set.rank(immdata)
# Generate shared repertoire using "CDR3.amino.acid.sequence" and
# "V.segments" columns and with rank.
imm.shared.av <- shared.repertoire(immdata, 'avr')
}
}
\seealso{
\link{shared.representation}, \link{set.rank}
}

