% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.group.boxplot}
\alias{vis.group.boxplot}
\title{Boxplot for groups of observations.}
\usage{
vis.group.boxplot(.data, .groups = NA, .labs = c("V genes", "Frequency"),
  .title = "", .rotate.x = T, .violin = T, .notch = F, ...)
}
\arguments{
\item{.data}{Either a matrix with colnames and rownames specifyed or a data frame with the first column of
strings for row names and other columns stands for values.}

\item{.groups}{Named list with character vectors for names of elements for each group. If NA than each
member is in the individual group.}

\item{.labs}{Labs names. Character vector of length 1 (for naming both axis with same name) or 2 (first elements stands for x-axis).}

\item{.title}{Main title of the plot.}

\item{.rotate.x}{if T then rotate x-axis.}

\item{.violin}{If T then plot a violin plot.}

\item{.notch}{"notch" parameter to the \code{geom_boxplot} ggplo2 function.}

\item{...}{Parameters passed to \code{melt}, applied to \code{.data} before plotting in \code{vis.group.boxplot}.}
}
\value{
ggplot object.
}
\description{
Plot boxplots for each group.
}
\examples{
\dontrun{
names(immdata)  # "A1" "A2" "B1" "B2" "C1" "C2"
# Plot a boxplot for V-usage for each plot
# three boxplots for each group.
vis.group.boxplot(freq.Vb(immdata),
   list(A = c('A1', 'A2'), B = c('B1', 'B2'), C = c('C1', 'C2')),
   c('V segments', 'Frequency')) 

data(twb)
ov <- repOverlap(twb)
sb <- matrixSubgroups(ov, list(tw1 = c('Subj.A', 'Subj.B'), tw2 = c('Subj.C', 'Subj.D')));
vis.group.boxplot(sb)
}
}

