% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_funcs.R, R/tcplQuery.R, R/tcplSendQuery.R
\name{Query functions}
\alias{Query functions}
\alias{tcplQuery}
\alias{tcplSendQuery}
\title{Wrappers for sending queries and fetching results}
\usage{
tcplQuery(query, db = getOption("TCPL_DB"), drvr = getOption("TCPL_DRVR"))

tcplSendQuery(query, db = getOption("TCPL_DB"),
  drvr = getOption("TCPL_DRVR"))
}
\arguments{
\item{query}{Character of length 1, the query string}

\item{db}{Character of length 1, the name of the tcpl database}

\item{drvr}{Character of length 1, which database driver to use}
}
\description{
These functions send a query to the given database, and are the access point
for all tcpl functions that query or update the tcpl database.
}
\details{
Currently, the tcpl package only supports the "MySQL" and "SQLite" database
drivers.

\code{tcplQuery} returns a data.table object with the query results.
\code{tcplSendQuery} sends a query, but does not fetch any results, and 
returns 'TRUE' or the error message given by the database.
}
\examples{

## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- tcplConfList()
tcplConfDefault()

tcplQuery("SELECT 'Hello World';")
tcplQuery("SELECT * FROM assay;")
 
## Reset configuration
options(conf_store)

}

