% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplLvlCount.R
\name{tcplLvlCount}
\alias{tcplLvlCount}
\title{Load tcpl level counts}
\usage{
tcplLvlCount(lvls = NULL, type = "mc")
}
\arguments{
\item{lvls}{Integer or list of Integers, The levels of data to load}

\item{type}{Character of length 1, the data type, "sc" or "mc"}
}
\value{
A data.table containing data for the given fields.
}
\description{
\code{tcplLvlCount} queries the tcpl databases and returns a data frame with
count totals for the given levels and data type.
}
\details{
The data type can be either 'mc' for mutliple concentration data, or 'sc'
for single concentration data.


Leaving \code{lvls} NULL will return all data.
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- tcplConfList()
TCPLlite <- file.path(system.file(package = "tcpl"), "example")
tcplConf(db = TCPLlite, user = NA, host = NA, drvr = "tcplLite")
 
## Get all counts for level 1 for multiple-concentration
tcplLvlCount(lvls = 1)

\dontrun{
## Get all counts for levels 4 through 7 for multiple-concentration
tcplLvlCount(lvls = 4:7)

## Get all counts for multiple-concentration data, note 'mc' is the 
## default value for type
tcplLvlCount()
}

## Reset configuration
options(conf_store)

}
\seealso{
\code{\link{tcplQuery}}, \code{\link{data.table}}
}
