## ----message = FALSE, results = "hide"----------------------------------------
# load libraries
library(teal.modules.general)
library(teal.widgets)

# teal_data object
data <- teal_data()
data <- within(data, {
  ADSL <- teal.modules.general::rADSL
  ADTTE <- teal.modules.general::rADTTE
})
datanames <- c("ADSL", "ADTTE")
datanames(data) <- datanames
join_keys(data) <- default_cdisc_join_keys[datanames]

# tm_variable_browser module
tm_variable_browser_module <- tm_variable_browser(
  label = "Variable browser",
  ggplot2_args = ggplot2_args(
    labs = list(subtitle = "Plot generated by Variable Browser Module")
  )
)

# initialize the app
app <- init(
  data = data,
  modules = modules(tm_variable_browser_module)
)

## ----eval = FALSE-------------------------------------------------------------
#  shinyApp(app$ui, app$server)

## ----indent = "     "---------------------------------------------------------
class(app)
names(app)

