% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action_card.R
\docType{class}
\name{action_card}
\alias{action_card}
\title{Create a \code{action_card} Structure With \code{teamr}}
\format{An \code{\link{R6Class}} generator object}
\usage{
# ac <- action_card$new(type = "ActionCard", name = "Add comment")
}
\description{
\code{action_card} creates a \code{potentialAction} object which can be added to \code{connector_card}.
}
\details{
Assemble \code{action_card} objects into a \code{action_card}
structure and use the methods to append, modify or send your card to the webhook specified.
}
\section{Methods}{


\describe{
\item{\code{action_card$new(type, name)}}{Creates a new \code{action_card}.}
\item{\code{add_text_inputs(id, title, is_multiline)}}{Add \code{TextInput} to your \code{action_card}.}
\item{\code{add_date_inputs(id, title)}}{Add \code{DateInput} to your \code{action_card}.}
\item{\code{add_mchoice_inputs(id, title, is_multi_select)}}{Add \code{MultichoiceInput} to your \code{action_card}.}
\item{\code{dump()}}{Dump current payload}
}
}

\section{Properties}{


\describe{
\item{\code{payload}}{R list of payloads(will be parsed into json)\link[httr]{POST}}
}
}

\examples{
\dontrun{
library(teamr)

cc <- connector_card$new(hookurl = "https://outlook.office.com/webhook/...")
cc$text("Of on affixed civilly moments promise explain")
pa <- action_card$new(type = "ActionCard", name = "Add comment")
pa$add_actions()
pa$add_text_inputs(id = "comment", title = "Add comment for this task", is_multi_line = TRUE)
cc$add_potential_action(pa)
cc$send()
}

}
\keyword{datasets}
