% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{get.decluttered}
\alias{get.decluttered}
\title{Get decluttering matrix indicating where to show/hide reference lines}
\usage{
get.decluttered(x = x, n.x = n.x, y = y, n.y = n.y, alpha = 0.05)
}
\arguments{
\item{x}{selections for sample of interest (can be a vector if several samples of interest)}

\item{n.x}{evaluations of \code{x} (can be a vector if several samples of interest)}

\item{y}{selections for comparison (can be a vector if several comparisons will be made)}

\item{n.y}{evaluations of \code{y} (can be a vector if several comparisons of interest)}

\item{alpha}{significance level}
}
\value{
declutter vector in which \code{1} indicates "show" and \code{NA} indicates "hide"
}
\description{
Declutter TCATA curves by hiding reference lines from plots showing TCATA curves.
}
\examples{

# functionality of get.decluttered() is conveniently provided in citation.counts()

# Data set: ojtcata
# Get declutter matrix for comparison of Product 2 vs. average of all products
data(ojtcata)
oj2.v.all <- citation.counts(ojtcata, product.name = "2", product.col = 2,
       attribute.col = 4, results.col = 5:25, comparison = "average")
oj2.v.all$declutter

# same as

p2.declutter <- get.decluttered(x = c(oj2.v.all$P1), n.x = oj2.v.all$Pn,
                                y = c(oj2.v.all$C1), n.y = oj2.v.all$Cn)
(p2.declutter <- matrix(p2.declutter, nrow = nrow(oj2.v.all$P1)))
}
\references{
Castura, J.C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal check-all-that-apply (TCATA): A novel temporal sensory method for characterizing products. \emph{Food Quality and Preference}, 47, 79-90. \doi{10.1016/j.foodqual.2015.06.017}
}
\seealso{
\code{\link[stats]{fisher.test}}, \code{\link[tempR]{citation.counts}}
}
