% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_tensorflow}
\alias{install_tensorflow}
\title{Install TensorFlow and its dependencies}
\usage{
install_tensorflow(
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  version = "default",
  envname = NULL,
  extra_packages = NULL,
  restart_session = TRUE,
  conda_python_version = "3.7",
  ...
)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows (as this isn't supported by TensorFlow). Note also
that since this command runs without privilege the "system" method is
available only on Windows.}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary. See
\strong{Finding Conda} for more details.}

\item{version}{TensorFlow version to install. Up to and including TensorFlow 2.0,
specify "default" to install the CPU version of the latest release;
specify "gpu" to install the GPU version of the latest release.
Starting from TensorFlow 2.1, by default a version is installed that works
on both GPU- and CPU-only systems. Specify "cpu" to install a CPU-only version.

You can also provide a full major.minor.patch specification (e.g. "1.1.0"),
appending "-gpu" if you want the GPU version (e.g. "1.1.0-gpu").

Alternatively, you can provide the full URL to an installer binary (e.g.
for a nightly binary).}

\item{envname}{Name of Python environment to install within}

\item{extra_packages}{Additional Python packages to install along with
TensorFlow.}

\item{restart_session}{Restart R session after installing (note this will
only occur within RStudio).}

\item{conda_python_version}{the python version installed in the created conda
environment. Python 3.6 is installed by default.}

\item{...}{other arguments passed to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}} or
\code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_install()}}.}
}
\description{
Install TensorFlow and its dependencies
}
