% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desctools_binom_diff.R
\name{desctools_binom}
\alias{desctools_binom}
\alias{desctools_binomci}
\title{Confidence Intervals for a Difference of Binomials}
\usage{
desctools_binom(
  x1,
  n1,
  x2,
  n2,
  conf.level = 0.95,
  sides = c("two.sided", "left", "right"),
  method = c("ac", "wald", "waldcc", "score", "scorecc", "mn", "mee", "blj", "ha", "hal",
    "jp")
)

desctools_binomci(
  x,
  n,
  conf.level = 0.95,
  sides = c("two.sided", "left", "right"),
  method = c("wilson", "wald", "waldcc", "agresti-coull", "jeffreys", "modified wilson",
    "wilsoncc", "modified jeffreys", "clopper-pearson", "arcsine", "logit", "witting",
    "pratt", "midp", "lik", "blaker"),
  rand = 123,
  tol = 1e-05
)
}
\arguments{
\item{conf.level}{(\code{proportion})\cr confidence level, defaults to 0.95.}

\item{sides}{(\code{character})\cr side of the confidence interval to compute. Must be one of "two-sided" (default),
"left", or "right".}

\item{method}{(\code{character})\cr method to use. Can be one out of: "wald", "wilson", "wilsoncc", "agresti-coull",
"jeffreys", "modified wilson", "modified jeffreys", "clopper-pearson", "arcsine", "logit", "witting", "pratt",
"midp", "lik", and "blaker".}

\item{x}{(\code{count})\cr number of successes}

\item{n}{(\code{count})\cr number of trials}

\item{grp}{(\code{factor})\cr vector assigning observations to one out of two groups
(e.g. reference and treatment group).}
}
\value{
A \code{matrix} of 3 values:
\itemize{
\item \code{est}: estimate of proportion difference.
\item \code{lwr.ci}: estimate of lower end of the confidence interval.
\item \code{upr.ci}: estimate of upper end of the confidence interval.
}

A \code{matrix} with 3 columns containing:
\itemize{
\item \code{est}: estimate of proportion difference.
\item \code{lwr.ci}: lower end of the confidence interval.
\item \code{upr.ci}: upper end of the confidence interval.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Several confidence intervals for the difference between proportions.
}
\section{Functions}{
\itemize{
\item \code{desctools_binom()}: Several confidence intervals for the difference between proportions.

\item \code{desctools_binomci()}: Compute confidence intervals for binomial proportions.

}}
\keyword{internal}
