% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_variables.R
\name{create_afun_compare}
\alias{create_afun_compare}
\title{Constructor Function for \code{\link[=compare_vars]{compare_vars()}}}
\usage{
create_afun_compare(
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{vector} of \code{integer})\cr indent modifiers for the labels. Each element of the vector
should be a name-value pair with name corresponding to a statistic specified in \code{.stats} and value the indentation
for that statistic's row label.}
}
\value{
Combined formatted analysis function for use in \code{\link[=compare_vars]{compare_vars()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Constructor function which creates a combined formatted analysis function.
}
\note{
Since \code{\link[=a_compare]{a_compare()}} is generic and we want customization of the formatting arguments
via \code{\link[rtables:make_afun]{rtables::make_afun()}}, we need to create another temporary generic function, with
corresponding customized methods. Then in order for the methods to be found,
we need to wrap them in a combined \code{afun}. Since this is required by two layout creating
functions (and possibly others in the future), we provide a constructor that does this:
\code{\link[=create_afun_compare]{create_afun_compare()}}.
}
\examples{
# `create_afun_compare()` to create combined `afun`

afun <- create_afun_compare(
  .stats = c("n", "count_fraction", "mean_sd", "pval"),
  .indent_mods = c(pval = 1L)
)

lyt <- basic_table() \%>\%
  split_cols_by("ARMCD", ref_group = "ARM A") \%>\%
  analyze(
    "AGE",
    afun = afun,
    show_labels = "visible"
  )
build_table(lyt, df = tern_ex_adsl)

lyt <- basic_table() \%>\%
  split_cols_by("ARMCD", ref_group = "ARM A") \%>\%
  analyze(
    "SEX",
    afun = afun,
    show_labels = "visible"
  )
build_table(lyt, df = tern_ex_adsl)

}
\seealso{
\code{\link[=compare_vars]{compare_vars()}}
}
