% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hit_api.R
\name{hit_national_map_api}
\alias{hit_national_map_api}
\title{Hit the USGS 3DEP API and retrieve an elevation heightmap}
\usage{
hit_national_map_api(
  bbox,
  img_width,
  img_height,
  service,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{bbox}{A list representing the bounding box (bottom left and top left
coordinate pairs).}

\item{img_width}{The number of pixels in the x direction to retrieve}

\item{img_height}{The number of pixels in the y direction to retrieve}

\item{service}{A string indicating what service API to use. For a full list
of available services, see \link{get_tiles}. Short codes are not accepted by this
function.}

\item{verbose}{Logical: Print out the number of tries required to pull each
tile? Default \code{FALSE}.}

\item{...}{Additional arguments passed to the National Map API.
These can be used to change default query parameters or as additional options
for the National Map services. See below for more information.}
}
\value{
A raw vector.
}
\description{
This function retrieves a single tile of data from a single National Map
service and returns the raw response. End users are recommended to use
\link{get_tiles} instead, as it does much more validation and provides
a more friendly interface. For a description of the datasets provided by the
National Map, see \url{https://apps.nationalmap.gov/services}
}
\section{Additional Arguments}{

The \code{...} argument can be used to pass additional arguments to the
National Map API or to edit the hard-coded defaults used by this function.
Some of the most useful options that can be changed include:
\itemize{
\item \code{bboxSR}: The spatial reference of the bounding box given to this function.
If not specified, assumed to be
\href{https://spatialreference.org/ref/epsg/wgs-84/}{4326}.
\item \code{imageSR}: The spatial reference of the image downloaded.
If not specified, assumed to be
\href{https://spatialreference.org/ref/epsg/wgs-84/}{4326}.
\item layers: Which data layers to download. If the National Map API returns data
without specifying layers, this argument isn't used by default. When the
National Map requires this argument, the default value is 0.
\item format: The image format to be downloaded. Defaults depend on the service
being used and are set to be compatible with \link{get_tiles}.
}

Pass these arguments to \code{hit_national_map_api} like you would any other
argument to substitute new values. Note that \code{...} values are never
validated before being used; passing invalid parameters to \code{...} will
cause data retrieval to fail.
}

\examples{
\dontrun{
hit_national_map_api(
  bbox = list(
    c(lat = 44.10438, lng = -74.01231),
    c(lat = 44.17633, lng = -73.91224)
  ),
  img_width = 8000,
  img_height = 8000,
  service = "3DEPElevation"
)
}

}
\seealso{
\link{get_tiles} for a friendlier interface to the National
Map API.

Other data retrieval functions: 
\code{\link{get_tiles}()}
}
\concept{data retrieval functions}
\keyword{internal}
