% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{plotBoundedCell3D}
\alias{plotBoundedCell3D}
\title{Plot a bounded Voronoï 3D cell}
\usage{
plotBoundedCell3D(
  cell,
  edgesAsTubes = FALSE,
  tubeRadius,
  tubeColor,
  facetsColor = NA,
  alpha = 1,
  check.bounded = TRUE
)
}
\arguments{
\item{cell}{a bounded Voronoï 3D cell}

\item{edgesAsTubes}{Boolean, whether to plot edges as tubes or as lines}

\item{tubeRadius}{radius of the tubes if \code{edgesAsTubes = TRUE}}

\item{tubeColor}{color of the tubes if \code{edgesAsTubes = TRUE}}

\item{facetsColor}{color of the facets; \code{NA} for no color}

\item{alpha}{opacity of the facets, a number between 0 and 1}

\item{check.bounded}{Boolean, whether to check that the cell is bounded;
set to \code{FALSE} for a small speed gain if you know that the cell is
bounded}
}
\value{
No value, this function just plots the cell.
}
\description{
Plot a bounded Voronoï 3D cell with \strong{rgl}.
}
\examples{
library(tessellation)
d <- delaunay(centricCuboctahedron())
v <- voronoi(d)
cell13 <- v[[13]]
isBoundedCell(cell13) # TRUE
\donttest{library(rgl)
open3d(windowRect = c(50, 50, 562, 562))
plotBoundedCell3D(
  cell13, edgesAsTubes = TRUE, tubeRadius = 0.03, tubeColor = "yellow",
  facetsColor = "navy", alpha = 0.7
)}
}
