% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_equal.R
\name{ttm_expect_equal}
\alias{ttm_expect_equal}
\title{Test that multi: expect equal}
\usage{
ttm_expect_equal(
  object,
  expected,
  ...,
  tolerance = if (testthat::edition_get() >= 3) testthat::testthat_tolerance(),
  info = NULL,
  label = NULL,
  expected.label = NULL,
  verbose = 0
)
}
\arguments{
\item{object}{Object to check if equal to expected}

\item{expected}{Expected value}

\item{...}{Args passed to testthat::expect_equal()}

\item{tolerance}{Passed to `testthat::expect_true()`.}

\item{info}{Passed to `testthat::expect_true()`.}

\item{label}{Passed to `testthat::expect_true()`.}

\item{expected.label}{Passed to `testthat::expect_true()`.}

\item{verbose}{Amount of info that should be printed.}
}
\value{
Test result
}
\description{
Test that multi: expect equal
}
\examples{
set.seed(0)

# 1 attempt, all pass
ttm(1, {
  ttm_expect_equal(TRUE, TRUE)
  ttm_expect_equal(1, 1)
  ttm_expect_equal(1:5, 1:5)
})

# Fails first 6 times, then passes
ttm(100, {
  x <- sample(1:6, 1)
  print(x)
  ttm_expect_equal(x, 3)
})

# Will always fail regardless of number of attempts
try({
  ttm(3, {
    ttm_expect_equal(1, 2)
  })
})
}
