% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthis-package.R
\docType{package}
\name{testthis}
\alias{testthis}
\alias{testthis-package}
\title{Testthis-package}
\description{
RStudio addins for several common testing-related tasks during package
development, such as switching between a source file and an associated test
file, or running unit tests in a single test file (hotkeyable in RStudio!).
testthis also provides utility function to manage tests in subdirectories of
the test/testthis directory.
}
\details{
For details please refer to the
\href{https://s-fleck.github.io/testthis/index.html}{README}
}
\section{Setting the project path}{


Testthis uses \code{\link[usethis:proj_get]{usethis::proj_get()}} to detect project root of the current
working directory. You can override the project root with
\code{\link[usethis:proj_set]{usethis::proj_set()}}.
}

\section{Package options}{


Package options can be set with \code{\link[=options]{options()}}. You can add \code{options()} to
your \file{.Rprofile} to make them permanent across sessions.

\describe{

\item{\code{testthis.sep}}{Default separator to use when creating test files with
\code{test_skeleton()}. Defaults to \code{_}, must be either \code{_} or \code{-}; i.e whether
you want your files to be named \code{test_foofunction.R} or \code{test-foofunction.R}}

\item{\code{testthis.integration_tests_path}, \code{testthis.acceptance_tests_path},
\code{testthis.manual_tests_path}}{Default paths used by the functions
\code{testthis::use_integration_tests()}, \code{testthis::test_integration()}, etc...}
}
}

\section{Testthis Tags}{


test_this tags are special comments that modify the behaviour of the
functions supplied by this package. They are of the form \code{#* @tag <value>}.
Please not that only some test_this tags really require a \code{<value>}.

\strong{Valid tags for script files in the /R/ dir (\code{pkg/R/*.R})}
\itemize{
\item \code{@testfile <filename>}: manually specify associated test file. Should
usually start with \code{test_}. This is used by \code{test_this()}, \code{lest_this()} and
\code{open_testfile()}.
}

\strong{Valid tags or test files (\code{pkg/tests/testthat/test_*.R})}
\itemize{
\item \code{@testing <functionname>}:  mark \code{functionname} as tested.
Should usually go next the associated \code{test_that()} call. This is used by
\code{test_coverage()}.
}
}

\seealso{
\code{\link[usethis:edit_r_profile]{usethis::edit_r_profile()}}
}
\author{
\strong{Maintainer}: Stefan Fleck \email{stefan.b.fleck@gmail.com}

}
