% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kable.R
\name{as.kable}
\alias{as.kable}
\title{Try to coerce an object into a knitr_kable object}
\usage{
as.kable(x)
}
\arguments{
\item{x}{object}
}
\value{
an object of class knitr_kable
}
\description{
coerce objects into a knitr_kable class object with a latex format
}
\examples{

tex <- '\\\\begin{tabular}{llr}
\\\\hline
\\\\multicolumn{2}{c}{Item} \\\\\\\\
\\\\cline{1-2}
Animal    & Description & Price (\\\\$) \\\\\\\\
\\\\hline
Gnat      & per gram    & 13.65      \\\\\\\\
& each        & 0.01       \\\\\\\\
Gnu       & stuffed     & 92.50      \\\\\\\\
Emu       & stuffed     & 33.33      \\\\\\\\
Armadillo & frozen      & 8.99       \\\\\\\\
\\\\hline
\\\\end{tabular}'

ktex <- as.kable(tex)

class(ktex)

attributes(ktex)

ktex

# using an input call

x <- tex_preview(tex,returnType = 'input')

x

ktex_input <- as.kable(x)

class(ktex_input)

attributes(ktex_input)

ktex_input

# file path

x <- tex_preview(tex,returnType = 'input')

ktex_path <- as.kable(file.path(tempdir(),'tex_temp.tex'))

class(ktex_path)

attributes(ktex_path)

ktex_path

}
\concept{utils}
