% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_5_textTrainPredictExamples.R
\name{textTrainExamples}
\alias{textTrainExamples}
\alias{textPredictExamples}
\title{Show language examples (Experimental)}
\usage{
textTrainExamples(
  text,
  x_variable,
  y_variable = NULL,
  type = "default",
  n_tile = 4,
  n_examples = 5,
  jitter = NULL,
  filter_words = NULL,
  target_color = "darkgreen",
  predictions_color = "darkblue",
  error_color = "darkred",
  distribution_color = c("#00508c", "#805259", "#a71200", "#0a6882", "#a4a4a4",
    "#e04b39", "#19956e", "#22a567", "#5c8a59"),
  figure_format = "svg",
  scatter_legend_dot_size = 3,
  scatter_legend_bg_dot_size = 2,
  scatter_legend_dots_alpha = 0.8,
  scatter_legend_bg_dots_alpha = 0.2,
  scatter_show_axis_values = TRUE,
  scatter_legend_regression_line_colour = NULL,
  x_axis_range = NULL,
  y_axis_range = NULL,
  grid_legend_x_axes_label = NULL,
  grid_legend_y_axes_label = NULL,
  seed = 42
)

textPredictExamples(
  text,
  x_variable,
  y_variable = NULL,
  type = "default",
  n_tile = 4,
  n_examples = 5,
  jitter = NULL,
  filter_words = NULL,
  target_color = "darkgreen",
  predictions_color = "darkblue",
  error_color = "darkred",
  distribution_color = c("#00508c", "#805259", "#a71200", "#0a6882", "#a4a4a4",
    "#e04b39", "#19956e", "#22a567", "#5c8a59"),
  figure_format = "svg",
  scatter_legend_dot_size = 3,
  scatter_legend_bg_dot_size = 2,
  scatter_legend_dots_alpha = 0.8,
  scatter_legend_bg_dots_alpha = 0.2,
  scatter_show_axis_values = TRUE,
  scatter_legend_regression_line_colour = NULL,
  x_axis_range = NULL,
  y_axis_range = NULL,
  grid_legend_x_axes_label = NULL,
  grid_legend_y_axes_label = NULL,
  seed = 42
)
}
\arguments{
\item{text}{(string) the language that was used for prediction/assessment/classification.}

\item{x_variable}{(numeric) the variable used for training (y).}

\item{y_variable}{(numeric) the outcome from the model (i.e., y_hat).}

\item{type}{(string) If you are plotting errors between predicted and targeted scores, you can set the type to "prediction_errors",
to produce two extra plots: distribution of scores and absolute error.}

\item{n_tile}{(integer) the n tile to split the data in (to show the most extreme tiles in different colours).}

\item{n_examples}{(integer) the number of language examples to show.}

\item{jitter}{(integer) the percentage of jitter to add to the data for the scatter plot.}

\item{filter_words}{(character vector) words required to be included in examples.}

\item{target_color}{(string)}

\item{predictions_color}{(string) = "darkblue",}

\item{error_color}{=  (string) "darkred",}

\item{distribution_color}{(string) colors of the distribution plot}

\item{figure_format}{(string) file format of the figures.}

\item{scatter_legend_dot_size}{(integer) The size of dots in the scatter legend.}

\item{scatter_legend_bg_dot_size}{(integer) The size of background dots in the scatter legend.}

\item{scatter_legend_dots_alpha}{(numeric) The transparency alphe level of the dots.}

\item{scatter_legend_bg_dots_alpha}{(numeric) The transparency alphe level of the background dots.
For example: c(1,0,1) result in one dot in each quadrant except for the middle quadrant.}

\item{scatter_show_axis_values}{(boolean) If TRUE, the estimate values are shown on the distribution plot axes.}

\item{scatter_legend_regression_line_colour}{(string) If a colour string is added, a regression line will be plotted.}

\item{x_axis_range}{(numeric vector) range of x axis (e.g., c(1, 100)).}

\item{y_axis_range}{(numeric vector) range of y axis (e.g., c(1, 100)).}

\item{grid_legend_x_axes_label}{x-axis label of the grid topic plot.}

\item{grid_legend_y_axes_label}{y-axis label of the grid topic plot.}

\item{seed}{(integer) The seed to set for reproducibility.}
}
\value{
A tibble including examples with descriptive variables.
}
\description{
This function selects language examples that been used in the textTrain() or textAssess() functions.
}
