% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_html.R
\name{replace_html}
\alias{replace_html}
\title{Replace HTML Markup}
\usage{
replace_html(x, symbol = TRUE, ...)
}
\arguments{
\item{x}{The text variable.}

\item{symbol}{logical.  If code{TRUE} the symbols are retained with appropriate
replacements.  If \code{FALSE} they are removed.}

\item{\ldots}{Ignored.}
}
\value{
Returns a vector with HTML markup replaced.
}
\description{
Replaces HTML markup.  The angle braces are removed and the HTML symbol 
markup is replaced with equivalent symbols.
}
\details{
Replacements for symbols are as follows:

\tabular{lr}{
    \bold{html} \tab  \bold{symbol} \cr
  &nbsp;   \tab      \cr
    &lt;   \tab < \cr
    &gt;   \tab  > \cr
   &amp;   \tab & \cr
  &quot;   \tab " \cr
  &apos;   \tab ' \cr
  &cent;   \tab cents  \cr
 &pound;   \tab pounds  \cr
   &yen;   \tab yen \cr
  &euro;   \tab euro \cr
  &copy;   \tab (c) \cr
   &reg;   \tab (r) \cr
}
}
\examples{
x <- c(
    "<bold>Random</bold> text with symbols: &nbsp; &lt; &gt; &amp; &quot; &apos;",
    "<p>More text</p> &cent; &pound; &yen; &euro; &copy; &reg;"
)

replace_html(x)
replace_html(x, FALSE)
}
\keyword{html}
