% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{word_dims_newtext}
\alias{word_dims_newtext}
\alias{word_dims}
\title{Calculates word2vec dimension estimates}
\usage{
word_dims_newtext(lda_model, text, n_iter = 20)

word_dims(text, n = 10, n_iter = 20)
}
\arguments{
\item{lda_model}{A pretrained \code{\link[text2vec]{LDA}} model from
\pkg{text2vec}.}

\item{text}{Input data. Should be character vector.}

\item{n_iter}{Integer, number of sampling iterations.}

\item{n}{Integer, determines the number of latent topics.}
}
\value{
A tibble data frame
}
\description{
Calculates word2vec dimension estimates
}
\examples{
trump_tweets <- c(
"#FraudNewsCNN #FNN https://t.co/WYUnHjjUjg",
"TODAY WE MAKE AMERICA GREAT AGAIN!",
paste("Why would Kim Jong-un insult me by calling me \\"old,\\" when I would",
      "NEVER call him \\"short and fat?\\" Oh well, I try so hard to be his",
      "friend - and maybe someday that will happen!"),
paste("Such a beautiful and important evening! The forgotten man and woman",
      "will never be forgotten again. We will all come together as never before"),
paste("North Korean Leader Kim Jong Un just stated that the \\"Nuclear",
      "Button is on his desk at all times.\\" Will someone from his depleted and",
      "food starved regime please inform him that I too have a Nuclear Button,",
      "but it is a much bigger &amp; more powerful one than his, and my Button",
      "works!")
)
word_dims(trump_tweets)

}
