% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{combine}
\alias{combine}
\alias{combine.data.frame}
\alias{combine.default}
\title{Combine Elements}
\usage{
combine(x, ...)

\method{combine}{default}(x, fix.punctuation = TRUE, ...)

\method{combine}{data.frame}(x, text.var = TRUE,
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with runs.}

\item{fix.punctuation}{logical If \code{TRUE} spaces before/after punctuation
that should not be are a removed (regex used:
\code{"(\\s+(?=[,.?!;:\%-]))|((?<=[$-])\\s+)"}).}

\item{text.var}{The name of the text variable.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a vector (if given a list/vector) or an expanded
\code{\link[data.table]{data.table}} with elements pasted together.
}
\description{
Combine (\code{\link[base]{paste}}) elements (\code{\link[base]{vector}}s,
\code{\link[base]{list}}s, or \code{\link[base]{data.frame}}s) together
with \code{collapse = TRUE}.
}
\examples{
(x <- split_token(DATA[["state"]][1], FALSE))
combine(x)

(x2 <- split_token(DATA[["state"]], FALSE))
combine(x2)

(x3 <- split_sentence(DATA))

## without dropping the non-group variable column
combine(x3)

## Dropping the non-group variable column
combine(x3[, 1:5, with=FALSE])
}

