% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{diagchk.tfm}
\alias{diagchk.tfm}
\alias{diagchk}
\alias{diagchk.um}
\title{Diagnostic checking}
\usage{
\method{diagchk}{tfm}(
  mdl,
  y = NULL,
  method = c("exact", "cond"),
  lag.max = NULL,
  std = TRUE,
  ...
)

diagchk(mdl, ...)

\method{diagchk}{um}(
  mdl,
  z = NULL,
  method = c("exact", "cond"),
  lag.max = NULL,
  std = TRUE,
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{um}.}

\item{y}{an object of class \code{ts}.}

\item{method}{exact or conditional residuals.}

\item{lag.max}{number of lags for ACF/PACF.}

\item{std}{logical. If TRUE standardized residuals are shown.}

\item{...}{additional arguments.}

\item{z}{optional, an object of class \code{ts}.}
}
\description{
\code{diagchk} displays tools for diagnostic checking.
}
\examples{
z <- AirPassengers
airl <- um(z, i = list(1, c(1,12)), ma = list(1, c(1,12)), bc = TRUE)
diagchk(airl)
}
