% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_files.R
\name{read_files}
\alias{read_files}
\title{Read a dataset from a set of files}
\usage{
read_files(files, reader, ..., parallel_files = 1,
  parallel_interleave = 1, num_shards = NULL, shard_index = NULL)
}
\arguments{
\item{files}{List of filenames or glob pattern for files (e.g. "*.csv")}

\item{reader}{Function that maps a file into a dataset (e.g.
\code{\link[=text_line_dataset]{text_line_dataset()}} or \code{\link[=tfrecord_dataset]{tfrecord_dataset()}}).}

\item{...}{Additional arguments to pass to \code{reader} function}

\item{parallel_files}{An integer, number of files to process in parallel}

\item{parallel_interleave}{An integer, number of consecutive records to
produce from each file before cycling to another file.}

\item{num_shards}{An integer representing the number of shards operating in
parallel.}

\item{shard_index}{An integer, representing the worker index. Shared indexes
are 0 based so for e.g. 8 shards valid indexes would be 0-7.}
}
\value{
A dataset
}
\description{
Read files into a dataset, optionally processing them in parallel.
}
