% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{layer_autoregressive_transform}
\alias{layer_autoregressive_transform}
\title{An autoregressive normalizing flow layer, given a \code{layer_autoregressive}.}
\usage{
layer_autoregressive_transform(object, made, ...)
}
\arguments{
\item{object}{Model or layer object}

\item{made}{A \code{Made} layer, which must output two parameters for each input.}

\item{...}{Additional parameters passed to Keras Layer.}
}
\value{
a Keras layer
}
\description{
Following \href{https://arxiv.org/abs/1705.07057}{Papamakarios et al. (2017)}, given
an autoregressive model \eqn{p(x)} with conditional distributions in the location-scale
family, we can construct a normalizing flow for \eqn{p(x)}.
}
\details{
Specifically, suppose made is a \verb{[layer_autoregressive()]} -- a layer implementing
a Masked Autoencoder for Distribution Estimation (MADE) -- that computes location
and log-scale parameters \eqn{made(x)[i]} for each input \eqn{x[i]}. Then we can represent
the autoregressive model \eqn{p(x)} as \eqn{x = f(u)} where \eqn{u} is drawn
from from some base distribution and where \eqn{f} is an invertible and
differentiable function (i.e., a Bijector) and \eqn{f^{-1}(x)} is defined by:\preformatted{library(tensorflow)
library(zeallot)
f_inverse <- function(x) \{
  c(shift, log_scale) \%<-\% tf$unstack(made(x), 2, axis = -1L)
  (x - shift) * tf$math$exp(-log_scale)
\}
}

Given a \code{\link[=layer_autoregressive]{layer_autoregressive()}} made, a \code{\link[=layer_autoregressive_transform]{layer_autoregressive_transform()}}
transforms an input \verb{tfd_*} \eqn{p(u)} to an output \verb{tfd_*} \eqn{p(x)} where
\eqn{x = f(u)}.
}
\references{
\href{https://arxiv.org/abs/1705.07057}{Papamakarios et al. (2017)}
}
\seealso{
\code{\link[=tfb_masked_autoregressive_flow]{tfb_masked_autoregressive_flow()}} and \code{\link[=layer_autoregressive]{layer_autoregressive()}}
}
