% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-methods.R
\name{tfd_log_prob}
\alias{tfd_log_prob}
\title{Log probability density/mass function.}
\usage{
tfd_log_prob(distribution, value, name = "log_prob")
}
\arguments{
\item{distribution}{The distribution being used.}

\item{value}{float or double Tensor.}

\item{name}{String prepended to names of ops created by this function.}
}
\value{
a Tensor of shape \code{sample_shape(x) + self$batch_shape} with values of type \code{self$dtype}.
}
\description{
Log probability density/mass function.
}
\examples{
\donttest{
  d <- tfd_normal(loc = c(1, 2), scale = c(1, 0.5))
  x <- d \%>\% tfd_sample()
  d \%>\% tfd_log_prob(x)
}
}
\seealso{
Other distribution_methods: \code{\link{tfd_cdf}},
  \code{\link{tfd_covariance}},
  \code{\link{tfd_cross_entropy}},
  \code{\link{tfd_entropy}},
  \code{\link{tfd_kl_divergence}},
  \code{\link{tfd_log_cdf}},
  \code{\link{tfd_log_survival_function}},
  \code{\link{tfd_mean}}, \code{\link{tfd_mode}},
  \code{\link{tfd_prob}}, \code{\link{tfd_quantile}},
  \code{\link{tfd_sample}}, \code{\link{tfd_stddev}},
  \code{\link{tfd_survival_function}},
  \code{\link{tfd_variance}}
}
\concept{distribution_methods}
