% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi-functions.R
\name{vi_dual_csiszar_function}
\alias{vi_dual_csiszar_function}
\title{Calculates the dual Csiszar-function in log-space}
\usage{
vi_dual_csiszar_function(logu, csiszar_function, name = NULL)
}
\arguments{
\item{logu}{\code{float}-like \code{Tensor} representing \code{log(u)} from above.}

\item{csiszar_function}{function representing a Csiszar-function over log-domain.}

\item{name}{name prefixed to Ops created by this function.}
}
\value{
dual_f_of_u \code{float}-like \code{Tensor} of the result of calculating the dual of
\code{f} at \code{u = exp(logu)}.
}
\description{
A Csiszar-function is a member of \code{F = { f:R_+ to R : f convex }}.
}
\details{
The Csiszar-dual is defined as:\preformatted{f^*(u) = u f(1 / u)
}

where \code{f} is some other Csiszar-function.
For example, the dual of \code{kl_reverse} is \code{kl_forward}, i.e.,\preformatted{f(u) = -log(u)
f^*(u) = u f(1 / u) = -u log(1 / u) = u log(u)
}

The dual of the dual is the original function:\preformatted{f^**(u) = {u f(1/u)}^*(u) = u (1/u) f(1/(1/u)) = f(u)
}

Warning: this function makes non-log-space calculations and may therefore be
numerically unstable for \code{|logu| >> 0}.
}
\seealso{
Other vi-functions: \code{\link{vi_amari_alpha}},
  \code{\link{vi_arithmetic_geometric}},
  \code{\link{vi_chi_square}},
  \code{\link{vi_csiszar_vimco}},
  \code{\link{vi_fit_surrogate_posterior}},
  \code{\link{vi_jeffreys}},
  \code{\link{vi_jensen_shannon}},
  \code{\link{vi_kl_forward}}, \code{\link{vi_kl_reverse}},
  \code{\link{vi_log1p_abs}},
  \code{\link{vi_modified_gan}},
  \code{\link{vi_monte_carlo_variational_loss}},
  \code{\link{vi_pearson}},
  \code{\link{vi_squared_hellinger}},
  \code{\link{vi_symmetrized_csiszar_function}}
}
\concept{vi-functions}
