% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_to_ggplot.R
\name{print_to_ggplot}
\alias{print_to_ggplot}
\title{Print to ggplot}
\usage{
print_to_ggplot(tfrmt, .data, ...)
}
\arguments{
\item{tfrmt}{tfrmt object that will dictate the structure of the ggplot object}

\item{.data}{Data to style in order to make the ggplot object}

\item{...}{Inputs to geom_text to modify the style of the table body}
}
\value{
a stylized ggplot object
}
\description{
Print to ggplot
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{
# Create data
risk<-tibble(time=c(rep(c(0,1000,2000,3000),3)),
            label=c(rep("Obs",4),rep("Lev",4),rep("Lev+5FU",4)),
            value=c(630,372,256,11,620,360,266,8,608,425,328,14),
            param=rep("n",12))

table<-tfrmt(
 label = label ,
 column = time,
 param = param,
 value = value) \%>\%
  print_to_ggplot(risk)

table

}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/GSK-Biostatistics/tfrmt/master/images/example_print_to_ggplot.png" alt="Simple table to stack with a KM-plot" style="width:50\%;">
}}
}

