% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_plan.R
\name{col_plan}
\alias{col_plan}
\alias{span_structure}
\title{Define the Column Plan & Span Structures}
\usage{
col_plan(..., .drop = FALSE)

span_structure(...)
}
\arguments{
\item{...}{For a col_plan and span_structure,
<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> arguments, unquoted expressions
separated by commas, and span_structures. span_structures must have the
arguments named to match the name the column in the input data has to identify the correct columns. See the examples}

\item{.drop}{Boolean. Should un-listed columns be dropped from the data.
Defaults to FALSE.}
}
\value{
col_plan object

span_structure object
}
\description{
Using <\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> expressions and a series
span_structures, define the order of the columns. The selection follows "last
selected" principals, meaning columns are moved to the \emph{last} selection as
opposed to preserving the first location.
}
\details{
\subsection{Column Selection}{

When col_plan gets applied and is used to create the output table, the
underlying logic sorts out which column specifically is being selected. If a column
is selected twice, the \emph{last} instance in which the column is selected will be
the location it gets rendered.

Avoid beginning the \code{col_plan()} column selection with a deselection (i.e.
\code{col_plan(-col1)}, \code{col_plan(-starts_with("value")))}. This will
result in the table preserving all columns not "de-selected" in the
statement, and the order of the columns not changed. It is preferred when
creating the \code{col_plan()} to identify all the columns planned on
preserving in the order they are wished to appear, or if
<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> arguments - such as
\code{\link[dplyr]{everything}}- are used, identify the de-selection after
the positive-selection.

Alternatively, once the gt table is produced, use the
\code{\link[gt]{cols_hide}} function to remove un-wanted columns.
}
}
\section{Images}{

Here are some example outputs:

\if{html}{\out{
<img src="https://raw.githubusercontent.com/GSK-Biostatistics/tfrmt/main/images/tfrmt-span_structure-cropped.jpg" alt ="Example of a dataset being turned into a table with spanning columns" style="width:100\%;">
}}
}

\examples{

library(dplyr)

## select col_1 as the first column, remove col_last, then create spanning
## structures that have multiple levels
##
## examples also assume the tfrmt has the column argument set to c(c1, c2, c3)
##
spanning_col_plan_ex <- col_plan(
 col_1,
 -col_last,
 span_structure(
   c1 = "Top Label Level 1",
   c2 = "Second Label Level 1.1",
   c3 = c(col_3, col_4)
 ),
 span_structure(
   c1 = "Top Label Level 1",
   c2 = "Second Label Level 1.2",
   c3 = starts_with("B")
   ),
 span_structure(
   c1 = "Top Label Level 1",
   c3 = col_5
 ),
 span_structure(
   c2 = "Top Label Level 2",
   c3 = c(col_6, col_7)
 )
)

## select my_col_1 as the first column, then
## rename col_2 to new_col_1 and put as the
## second column, then select the rest of the columns
renaming_col_plan_ex <- col_plan(
   my_col_1,
   new_col_1 = col_2,
   everything()
 )

renaming_col_plan_ex2 <- col_plan(
   my_col_1,
   new_col_1 = col_2,
   span_structure(
    c1 = c(`My Favorite span name` = "Top Label Level 1"),
    c3 = c(`the results column` = col_5)
   )
 )

}
\seealso{
\href{https://gsk-biostatistics.github.io/tfrmt/articles/col_plan.html}{Link to related article}
}
