% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{log_message}
\alias{log_message}
\title{Print diagnostic message}
\usage{
log_message(
  ...,
  verbose = TRUE,
  message_type = c("info", "success", "warning", "error"),
  cli_model = TRUE,
  timestamp = TRUE,
  level = 1,
  level_symbol = "  "
)
}
\arguments{
\item{...}{Text to print.}

\item{verbose}{Logical value, default is \emph{\code{TRUE}}.
Whether to print the message.}

\item{message_type}{Type of message, default is \emph{\code{info}}.
Could be choose one of \emph{\code{info}}, \emph{\code{success}}, \emph{\code{warning}}, and \emph{\code{error}}.}

\item{cli_model}{Logical value, default is \emph{\code{TRUE}}.
Whether to use the \code{cli} package to print the message.}

\item{timestamp}{Logical value, default is \emph{\code{TRUE}}.
Whether to show the current time in the message.}

\item{level}{Integer value, default is \emph{\code{1}}.
The level of the message, which affects the indentation.
Level 1 has no indentation, higher levels add more indentation.}

\item{level_symbol}{Character value, default is \emph{\code{"  "}} (two spaces).
The symbol used for indentation at each level.}
}
\value{
\code{Formated message} printed to the console.
}
\description{
Integrate the message printing function with the \code{cli} package,
and the \code{\link[base]{message}} function.
The message could be suppressed by \code{\link[base]{suppressMessages}}.
}
\examples{
log_message("Hello, ", "world!")
log_message("Hello, world!", timestamp = FALSE)
log_message("Hello, ", "world!", message_type = "success")
log_message("Hello, world!", message_type = "warning")
suppressMessages(log_message("Hello, ", "world!"))
log_message("Hello, world!", verbose = FALSE)
log_message("Hello, world!", level = 2)
log_message("Hello, world!", level = 3, level_symbol = "->")
}
