% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_space}
\alias{remove_space}
\title{Remove and normalize spaces}
\usage{
remove_space(
  x,
  trim_start = TRUE,
  trim_end = FALSE,
  collapse_multiple = TRUE,
  preserve_newlines = TRUE
)
}
\arguments{
\item{x}{A vector of character strings.}

\item{trim_start}{Logical value, default is \code{TRUE}.
Whether to remove leading spaces before the first word.}

\item{trim_end}{Logical value, default is \code{FALSE}.
Whether to remove trailing spaces after the last word.}

\item{collapse_multiple}{Logical value, default is \code{TRUE}.
Whether to collapse multiple consecutive spaces between words into a single space.}

\item{preserve_newlines}{Logical value, default is \code{TRUE}.
Whether to preserve newline characters when collapsing spaces.}
}
\value{
A character vector with spaces normalized according to the specified parameters.
}
\description{
Remove leading/trailing spaces and normalize multiple spaces between words in character strings.
}
\examples{
x <- c(
  " hello  world ",
  "  test   case  ",
  "no space",
  "   multiple   spaces   "
)
remove_space(x)
remove_space(x, trim_start = FALSE)
remove_space(x, trim_end = TRUE)
remove_space(x, collapse_multiple = FALSE)
remove_space(
  x,
  trim_start = FALSE,
  trim_end = FALSE,
  collapse_multiple = FALSE
)

# with newlines
multiline <- c(
  "hello\n\n  world  ",
  "  first  \n  second  "
)
remove_space(multiline)
remove_space(multiline, preserve_newlines = FALSE)
}
