% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_BPD_Clin.R
\docType{data}
\name{bpd_clin}
\alias{bpd_clin}
\title{A data set containing the clinical data of the subjects sequenced for BPD1 study}
\format{
A 74x8 data.frame
\describe{
\item{\code{study_id}}{A character vector of study IDs}
\item{\code{weight}}{A numeric vector of infant birth weights (Kg)}
\item{\code{sex}}{A factor; infant sex}
\item{\code{gestational_age}}{A numeric vector of gestational age in weeks}
\item{\code{mom_ethncty}}{A factor; maternal ethnicity}
\item{\code{bpd1}}{A factor; BPD severity}
\item{\code{day}}{A numeric vector; days of life at time of sequencing}
\item{\code{Lib}}{A character vector of sequencing library names}
}
}
\source{
\url{https://doi.org/10.1371/journal.pone.0170120}
}
\usage{
bpd_clin
}
\description{
Infants who required mechanical ventilation had tracheal aspirates samples collected at 7, 14, and 21 days of age (+/- 48 hours). Infants who were mechanically ventilated and had at least one tracheal aspirate collected were included in this study. Subjects were required to be enrolled within 7 days of age. Bacterial profiles were determined by broad-range amplification and sequence analysis of 16S rRNA genes
}
\keyword{datasets}
