% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-plot_sem.R
\name{get_nodes}
\alias{get_nodes}
\title{Extract nodes from a SEM model object}
\usage{
get_nodes(x, label = "est_sig", ...)
}
\arguments{
\item{x}{A model object of class \code{mplusObject} or \code{lavaan}.}

\item{label}{Character, indicating which column to use for node labels. Nodes
are labeled with mean values of the observed/latent variables they represent.
Defaults to 'est_sig', which consists of the estimate value with significance
asterisks.}

\item{...}{Additional parameters to be passed to and from other functions.}
}
\value{
An object of class 'tidy_nodes'
}
\description{
Attempts to extract nodes from a SEM model object, where nodes
are defined as observed or latent variables.
}
\examples{
library(lavaan)
res <- sem("dist ~ speed", cars)
get_nodes(res)
}
\keyword{tidy_graph}
