% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_original_cols.R
\name{drop_original_cols}
\alias{drop_original_cols}
\title{Drop Original Cols}
\usage{
drop_original_cols(.data, ..., restore_names = FALSE)
}
\arguments{
\item{.data}{dataframe output from bin_cols}

\item{...}{tidyselect. default chooses all cols created from binning}

\item{restore_names}{Logical, default FALSE. rename the binned cols with the original column names?}
}
\value{
dataframe
}
\description{
Drops the original column from the dataframe once bins are made.  Throws an error if the same column has multiple bin cols.
}
\examples{

iris \%>\%
 bin_cols(Sepal.Length) \%>\%
 bin_cols(Sepal.Width, pretty_labels = TRUE) -> iris1

iris1

iris1 \%>\%
 drop_original_cols(restore_names = TRUE)

iris1 \%>\%
 drop_original_cols(restore_names = FALSE)
}
