% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidycells-package.R
\docType{package}
\name{tidycells-package}
\alias{tidycells}
\alias{tidycells-package}
\title{\code{tidycells} package}
\description{
\strong{Read Tabular Data from Diverse Sources and Easily Make Them Tidy}
}
\details{
The package provides utilities to read, cells from complex tabular data
and heuristic detection based structural assignment of those cells to a
columnar or tidy format. Read functionality has the ability to read (in
a unified manner) structured, partially structured or unstructured
tabular data (usually spreadsheets for public data dissemination and
aimed for common human understanding) from various types of documents.
The tabular information is read as cells. The 'structure assignment'
functionality has both supervised and unsupervised way of assigning
cells data to columnar/tidy format. Multiple disconnected blocks of
tables in a single sheet are also handled appropriately. These tools are
suitable for unattended conversation of (maybe a pile of) messy tables
(like government data) into a consumable format(usable for further
analysis and data wrangling).

To get started check out \href{../doc/tidycells-intro.html}{\code{vignette("tidycells-intro")}}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://r-rudra.github.io/tidycells/}
  \item \url{https://github.com/r-rudra/tidycells}
  \item Report bugs at \url{https://github.com/r-rudra/tidycells/issues}
}

}
\author{
\strong{Maintainer}: Indranil Gayen \email{nil.gayen@gmail.com} (0000-0003-0197-1944)

}
\keyword{internal}
